package com.example.sefinsa_app.utilities;

import static androidx.core.content.ContextCompat.startActivity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.text.Html;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.net.ParseException;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.RecyclerView;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.FolioController;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.Prestamo;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Text;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ClientesAdapter extends RecyclerView.Adapter<ClientesAdapter.ClientesViewHolder> {

    Context context;
    ArrayList<Cliente> clientes;
    private final SharedPreferences sesion;
    private String cliente_id;
    private VolleyS vs;
    private RequestQueue requestQueue;
    public ClientesAdapter(Context context, ArrayList<Cliente> clientes) {
        this.context = context;
        this.clientes = clientes;
        this.sesion = context.getSharedPreferences("sesion", Context.MODE_PRIVATE);
    }

    public void setListaFiltrada(ArrayList<Cliente> listaFiltrada) {
        this.clientes = (listaFiltrada != null) ? listaFiltrada : new ArrayList<>();
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public ClientesViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // Inflar el layout de la vista del item
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.cliente_item_2, parent, false);
        return new ClientesViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ClientesViewHolder holder, int position) {
        try {
            if (clientes == null || position < 0 || position >= clientes.size()) {
                Log.e("ClientesAdapter", "Datos no válidos en la posición: " + position);
                holder.imprimirDefault();
                return;
            }

            Cliente cliente = clientes.get(position);
            if (cliente == null) {
                Log.e("ClientesAdapter", "Cliente nulo en posición: " + position);
                holder.imprimirDefault();
            } else {
                holder.imprimir(position);
            }
        } catch (Exception e) {
            Log.e("ClientesAdapter", "Error en onBindViewHolder", e);
        }
    }


    @Override
    public int getItemCount() {
        return clientes.size();
    }

    public void clear() {
        clientes.clear();
        notifyDataSetChanged();
    }

    public void addAll(ArrayList<Cliente> list) {
        if (list != null) {
            clientes.addAll(list);
            notifyDataSetChanged();
        }
    }
    private void refreshData() {
        requestQueue.getCache().clear();
    }

    public class ClientesViewHolder extends RecyclerView.ViewHolder {

        TextView tvNombreCliente, tvDireccionCliente, tvTelefonoCliente,
                tvRutaCliente, tvPoblacionCliente, tvColocadoraCliente, tvGarantiasCliente;

        Button btnEditarCliente, btnVerInfoCliente, btnGenerarPrestamo, btnVerImagenes, btnPrestanombre;
        String informacion = "";
        ConstraintLayout tarjetaCliente;
        // Método imprimirDefault()
        // Método imprimirDefault()
        public void imprimirDefault() {
            // Asigna valores predeterminados a las vistas (valores de ejemplo)
            if (tvNombreCliente != null) tvNombreCliente.setText("Nombre Predeterminado");
            if (tvTelefonoCliente != null) tvTelefonoCliente.setText("0000000000");

            if (tvDireccionCliente != null) tvDireccionCliente.setText("Direccion no disponible");

            if (tvRutaCliente != null) tvRutaCliente.setText("Ruta no disponible");
            if (tvPoblacionCliente != null) tvPoblacionCliente.setText("Población no disponible");
            if (tvColocadoraCliente != null) tvColocadoraCliente.setText("Colocadora no disponible");
            if (tvGarantiasCliente != null) tvGarantiasCliente.setText("Garantías no disponibles");

            if (btnPrestanombre != null) btnPrestanombre.setVisibility(View.VISIBLE);
        }
        int prestan = 0;

        public ClientesViewHolder(@NonNull View itemView) {
            super(itemView);
            tarjetaCliente = itemView.findViewById(R.id.TarjetaCliente);
            tvNombreCliente = itemView.findViewById(R.id.nombreClienteF);
            tvDireccionCliente = itemView.findViewById(R.id.direccionClienteF);
            tvTelefonoCliente = itemView.findViewById(R.id.telefonoClienteF);
            tvRutaCliente = itemView.findViewById(R.id.rutaClienteF);
            tvPoblacionCliente = itemView.findViewById(R.id.poblacionCliente);
            tvColocadoraCliente = itemView.findViewById(R.id.colocadoraCliente);
            tvGarantiasCliente = itemView.findViewById(R.id.garantiasClienteF);

            btnEditarCliente = itemView.findViewById(R.id.btnEditarClienteF);
            btnVerInfoCliente = itemView.findViewById(R.id.btnVerInfoF);
            btnGenerarPrestamo = itemView.findViewById(R.id.btnGenerarPrestamoF);
            btnVerImagenes = itemView.findViewById(R.id.btnVerImagenesF);
            btnPrestanombre = itemView.findViewById(R.id.btnPrestanombreF);
        }

        // Método para mostrar AlertDialog
        private void showAlert(String message) {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setMessage(message);

            // Personaliza el título para centrarlo
            TextView title = new TextView(context);
            title.setText("Alerta");
            title.setGravity(Gravity.CENTER);
            title.setTextSize(TypedValue.COMPLEX_UNIT_SP, 20);
            title.setTextColor(ContextCompat.getColor(context, android.R.color.black));
            title.setPadding(0, 20, 0, 20);

            builder.setCustomTitle(title);

            builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                public void onClick(DialogInterface dialog, int id) {
                    // Acciones al hacer clic en Aceptar
                }
            });

            AlertDialog dialog = builder.create();
            dialog.show();
        }

        public void imprimir(int position) {
            // Verifica que la posición sea válida y que el cliente no sea nulo
            if (position >= 0 && position < clientes.size()) {
                Cliente cliente = clientes.get(position);
                String nombreAval = cliente.getNombre_aval();
                if (cliente != null) {
                    // Verifica el valor de 'prestanombre' y ajusta el fondo y la visibilidad de los botones
                    prestan = Integer.parseInt(cliente.getPrestanombre());
                    if (prestan > 0) {
                        tarjetaCliente.setBackgroundColor(ContextCompat.getColor(context, R.color.colorBackgroundIfZero));
                        btnPrestanombre.setVisibility(View.GONE);
                    } else {
                        btnPrestanombre.setVisibility(View.VISIBLE);
                        tarjetaCliente.setBackgroundColor(ContextCompat.getColor(context, R.color.light));
                    }

                    // Configura el texto de las vistas

                    tvNombreCliente.setText(cliente.getNombre_completo() + "\nAVAL: " + nombreAval);
                    tvTelefonoCliente.setText(cliente.getTelefono());
                    tvRutaCliente.setText(cliente.getNombre_ruta());

                    // Crea el string de información con formato HTML
                    informacion = "<b>Cliente:</b> " + cliente.getNombre_completo() + " <br><br> " +
                            "<b>Dirección:</b> " + cliente.getDireccion() + " <br><br> " +
                            "<b>Teléfono:</b> <a href='tel:" + cliente.getTelefono() + "'>" + cliente.getTelefono() + "</a><br><br> " +
                            "<b>Colocadora:</b> " + cliente.getNombre_colocadora() + " <br><br> " +
                            "<b>Población:</b> " + cliente.getNombre_poblacion() + " <br><br> " +
                            "<b>Garantías:</b> " + cliente.getGarantias() + " <br><br><br>" +
                            "<b>Aval:</b> " + nombreAval + " <br><br> " +
                            "<b>Dirección:</b> " + cliente.getDireccion_aval() + " <br><br> " +
                            "<b>Teléfono:</b> " + cliente.getTelefono_aval() + " <br><br> " +
                            "<b>Otras referencias:</b> " + cliente.getOtras_referencias_aval() + " <br><br> " +
                            "<b>Garantías:</b> " + cliente.getGarantias_aval() + " <br><br> ";
                }
//int desiredWidth = 41; // Ancho en dp
                int desiredWidth = 74;
                float scale = context.getResources().getDisplayMetrics().density;
                int desiredWidthPx = (int) (desiredWidth * scale + 0.5f);

                ViewGroup.LayoutParams paramsVerInfo = btnVerInfoCliente.getLayoutParams();
                paramsVerInfo.width = desiredWidthPx;
                btnVerInfoCliente.setLayoutParams(paramsVerInfo);

                ViewGroup.LayoutParams paramsEditarCliente = btnEditarCliente.getLayoutParams();
                paramsEditarCliente.width = desiredWidthPx;
                btnEditarCliente.setLayoutParams(paramsEditarCliente);

                ViewGroup.LayoutParams paramsGenerarPrestamo = btnGenerarPrestamo.getLayoutParams();
                paramsGenerarPrestamo.width = desiredWidthPx;
                btnGenerarPrestamo.setLayoutParams(paramsGenerarPrestamo);

                ViewGroup.LayoutParams paramsPrestanombre = btnPrestanombre.getLayoutParams();
                paramsPrestanombre.width = desiredWidthPx;
                btnPrestanombre.setLayoutParams(paramsPrestanombre);

                ViewGroup.LayoutParams paramsVerImagenes = btnVerImagenes.getLayoutParams();
                paramsVerImagenes.width = desiredWidthPx;
                btnVerImagenes.setLayoutParams(paramsVerImagenes);

                if (sesion.getString("nombre_perfil", "").equals("Administrador")
                        || sesion.getString("nombre_perfil", "").equals("ADMINISTRADOR")) {

                    btnEditarCliente.setVisibility(View.VISIBLE);
                    btnGenerarPrestamo.setVisibility(View.VISIBLE);

                } else if (sesion.getString("nombre_perfil", "").equals("VOCERO")) {

                } else if (sesion.getString("nombre_perfil", "").equals("COBRADOR") ||
                        sesion.getString("nombre_perfil", "").equals("GESTOR")) {

                    btnEditarCliente.setVisibility(View.GONE);
                } else {
                    btnGenerarPrestamo.setVisibility(View.GONE);
                    btnEditarCliente.setVisibility(View.VISIBLE);
                }
                btnVerImagenes.setVisibility(View.VISIBLE);

                btnGenerarPrestamo.setOnClickListener(view -> {
                    // Tu condición aquí
                    if (prestan > 0) {
                        // Mostrar mensaje de alerta
                        showAlert("¡Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                    } else {
                        Bundle args = new Bundle();
                        String personJsonString = Utils.getGsonParser().toJson(clientes.get(position));
                        args.putString("cliente", personJsonString);

                        Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_prestamos_crear, args);
                    }
                });
                btnVerImagenes.setOnClickListener(view -> {

                    String[] opciones = {
                            "Tomar fotos",
                            "Ver expediente",
                    };

                    new MaterialAlertDialogBuilder(context)
                            .setTitle("Opciones")
                            .setSingleChoiceItems(opciones, -1, (dialogInterface, i) -> {
                                switch (i) {
                                    case 0:
                                        dialogInterface.dismiss();
                                        cliente_id = clientes.get(position).id;
                                        Log.d("LISTA0", "DATO DE cliente_id para foto...................: " + cliente_id);
                                        Bundle args2 = new Bundle();
                                        String personJsonString2 = Utils.getGsonParser().toJson(clientes.get(position));
                                        String personJsonString4 = nombreAval;
                                        args2.putString("cliente", personJsonString2);
                                        args2.putString("avalNombre", personJsonString4);

                                        Log.d("oasjksajk", "imprimir: " + cliente.getAval_id() + " " + cliente.getNombre_aval());

                                        if (Objects.equals(cliente.getNombre_aval(), "") || cliente.getNombre_aval() == null) {
                                            Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard).navigate(R.id.nav_clientes_fotos, args2);
                                        } else {
                                            Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard).navigate(R.id.nav_clientes_avales_fotos, args2);
                                        }
                                        break;

                                    case 1:
                                        dialogInterface.dismiss();

                                        Bundle args = new Bundle();
                                        String personJsonString = Utils.getGsonParser().toJson(clientes.get(position));
                                        String personJsonString3 = clientes.get(position).id;
                                        Log.d("LISTA1", "DATO DE SUCESS personJsonString: " + personJsonString);
                                        args.putString("cliente", personJsonString);
                                        args.putString("clienteId", personJsonString3);

                                        Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard)
                                                .navigate(R.id.nav_clientes_documentos, args);
                                        break;
                                }
                            }).show();
                });
                btnEditarCliente.setOnClickListener(view -> {
                    Bundle args = new Bundle();
                    String personJsonString = Utils.getGsonParser().toJson(clientes.get(position));
                    args.putString("cliente", personJsonString);

                    Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard)
                            .navigate(R.id.nav_clientes_editar, args);
                });
                btnPrestanombre.setOnClickListener(view -> {
                    new AlertDialog.Builder(context)
                            .setTitle("Presta Nombres")
                            .setCancelable(false)
                            .setMessage("¿Desea marcar al cliente como prestanombre?")
                            .setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int i) {
                                    // Verificar la conexión de red antes de realizar la solicitud
                                    ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
                                    NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();

                                    if (activeNetworkInfo == null || !activeNetworkInfo.isConnected()) {
                                        Toast.makeText(context, "No hay conexión de red", Toast.LENGTH_SHORT).show();
                                        return;
                                    }
                                    String clientId = clientes.get(position).getId();
                                    activarPrestanombre(clientId);

                                    tarjetaCliente.setBackgroundColor(ContextCompat.getColor(context, R.color.colorBackgroundIfZero));
                                    btnPrestanombre.setVisibility(View.GONE);
                                    clientes.get(position).setPrestanombre("1");
                                    prestan = Integer.parseInt(clientes.get(position).getPrestanombre());
                                }
                            })
                            .setNegativeButton("CANCELAR", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int i) {
                                    // Acciones al hacer clic en CANCELAR
                                }
                            })
                            .show();
                });
                btnVerInfoCliente.setOnClickListener(view -> {
                    final View dialogView = LayoutInflater.from(context).inflate(R.layout.dialog_info_cliente, null, false);

                    TextView tvNombreCliente = dialogView.findViewById(R.id.tvNombreCliente);
                    TextView tvDireccionCliente = dialogView.findViewById(R.id.tvDireccionCliente);
                    TextView tvTelefonoCliente = dialogView.findViewById(R.id.tvTelefonoCliente);
                    TextView tvColocadoraCliente = dialogView.findViewById(R.id.tvColocadoraCliente);
                    TextView tvPoblacionCliente = dialogView.findViewById(R.id.tvPoblacionCliente);
                    TextView tvGarantiasCliente = dialogView.findViewById(R.id.tvGarantiasCliente);
                    TextView tvUbicacionCliente = dialogView.findViewById(R.id.tvUbicacionCliente);
                    TextView tvNombreAval = dialogView.findViewById(R.id.tvNombreAval);
                    @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView tvMapaCliente = dialogView.findViewById(R.id.tvMapaCliente);
                    TextView tvMapaAval = dialogView.findViewById(R.id.tvMapaAval);

                    TextView tvUpdGarantiasCliente = dialogView.findViewById(R.id.tvUpdGarantiasCliente);
                    TextView tvUpdComprobantesCliente = dialogView.findViewById(R.id.tvUpdComprobantesCliente);
                    TextView tvUpdGarantiasAval = dialogView.findViewById(R.id.tvUpdGarantiasAval);
                    TextView tvUpdComprobantesAval = dialogView.findViewById(R.id.tvUpdComprobantesAval);

                    TextView tvDireccionAval = dialogView.findViewById(R.id.tvDireccionAval);
                    TextView tvTelefonoAval = dialogView.findViewById(R.id.tvTelefonoAval);
                    TextView tvORAval = dialogView.findViewById(R.id.tvORAval);
                    TextView tvGarantiasAval = dialogView.findViewById(R.id.tvGarantiasAval);

                    tvNombreCliente.setText(Html.fromHtml("<b>Cliente:</b> " + clientes.get(position).getNombre_completo()));
                    tvDireccionCliente.setText(Html.fromHtml("<b>Dirección:</b> " + clientes.get(position).getDireccion()));
                    tvTelefonoCliente.setText(Html.fromHtml("<b>Teléfono:</b> " + clientes.get(position).getTelefono()));
                    tvMapaCliente.setText(Html.fromHtml("<b>Ver ubicación</b>"));
                    tvMapaAval.setText(Html.fromHtml("<b>Ver ubicación</b>"));
                    tvColocadoraCliente.setText(Html.fromHtml("<b>Colocadora:</b> " + clientes.get(position).getNombre_colocadora()));
                    tvPoblacionCliente.setText(Html.fromHtml("<b>Población:</b> " + clientes.get(position).getNombre_poblacion()));
                    tvGarantiasCliente.setText(Html.fromHtml("<b>Garantías:</b> " + clientes.get(position).getGarantias()));

                    vs = VolleyS.getInstance(context);
                    requestQueue = vs.getRequestQueue();

                    JSONObject data = new JSONObject();
                    try {
                        data.put("func", "getCords");
                        data.put("id", clientes.get(position).getId());
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                    Log.d("12", "loadAllData: ");

                    JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data,
                            new Response.Listener<JSONObject>() {
                                @Override
                                public void onResponse(JSONObject response) {
                                    try {
                                        if (!response.get("data").toString().equals("false")) {
                                            JSONObject jsonObject = (JSONObject) response.get("data");

                                            String latitud = jsonObject.getString("latitud");
                                            String longitud = jsonObject.getString("longitud");

                                            if (latitud.isEmpty() && longitud.isEmpty() || latitud == null && longitud == null || latitud.equals("0") && longitud.equals("0") || latitud.equals("null") && longitud.equals("null")) {
                                                tvMapaCliente.setText("");
                                            } else {
                                                tvMapaCliente.setOnClickListener(new View.OnClickListener() {
                                                    @Override
                                                    public void onClick(View v) {
                                                        Intent intent = new Intent(android.content.Intent.ACTION_VIEW);
                                                        intent.setData(Uri.parse("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud));
                                                        intent.setPackage("com.google.android.apps.maps");
                                                        context.startActivity(intent);
                                                    }
                                                });
                                            }
                                        }
                                    } catch (JSONException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            },
                            new Response.ErrorListener() {
                                @Override public void onErrorResponse(VolleyError error) { }
                            });

                    requestQueue.add(req);

                    JSONObject data2 = new JSONObject();
                    try {
                        data2.put("func", "coordenadasAval");
                        data2.put("aval_id", clientes.get(position).getAval_id());
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                    Log.d("coordenadasAval", data2.toString());

                    Log.d("13", "loadAllData: ");

                    JsonObjectRequest req2 = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data2,
                            new Response.Listener<JSONObject>() {
                                @Override
                                public void onResponse(JSONObject response) {
                                    try {
                                        if (!response.get("data").toString().equals("false")) {
                                            JSONObject jsonObject = (JSONObject) response.get("data");

                                            String latitud = jsonObject.getString("latitud");
                                            String longitud = jsonObject.getString("longitud");

                                            if (latitud.isEmpty() && longitud.isEmpty() || latitud == null && longitud == null || latitud.equals("0") && longitud.equals("0") || latitud.equals("null") && longitud.equals("null")) {
                                                tvMapaAval.setText("");
                                            } else {
                                                tvMapaAval.setOnClickListener(new View.OnClickListener() {
                                                    @Override
                                                    public void onClick(View v) {
                                                        Log.d("qpwopeoqpww", "geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud);
                                                        Intent intent = new Intent(android.content.Intent.ACTION_VIEW);
                                                        intent.setData(Uri.parse("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud));
                                                        intent.setPackage("com.google.android.apps.maps");
                                                        context.startActivity(intent);
                                                    }
                                                });
                                            }
                                        }
                                    } catch (JSONException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            },
                            new Response.ErrorListener() {
                                @Override public void onErrorResponse(VolleyError error) { }
                            });

                    requestQueue.add(req2);

                            Log.d("MyWorker", "INFORMACION EN CLIENTE SELECCIONADO........" + clientes.get(position).getUpdate_comprobantes_cliente() +
                                    " / " + clientes.get(position).getUpdate_garantias_cliente());

                    String updateGarantiasCliente = clientes.get(position).getUpdate_garantias_cliente();
                    String updateComprobantesCliente = clientes.get(position).getUpdate_comprobantes_cliente();
                    updateGarantiasCliente = updateGarantiasCliente != null ? updateGarantiasCliente : "...";
                    updateComprobantesCliente = updateComprobantesCliente != null ? updateComprobantesCliente : "...";

                    String updateGarantiasAval = clientes.get(position).getUpdate_garantias_aval();
                    String updateComprobantesAval = clientes.get(position).getUpdate_comprobantes_aval();
                    updateComprobantesAval = updateComprobantesAval != null ? updateComprobantesAval : "...";
                    updateGarantiasAval = updateGarantiasAval != null ? updateGarantiasAval : "...";

                    updateGarantiasCliente = formatFecha(updateGarantiasCliente);
                    updateComprobantesCliente = formatFecha(updateComprobantesCliente);
                    updateGarantiasAval = formatFecha(updateGarantiasAval);
                    updateComprobantesAval = formatFecha(updateComprobantesAval);

                    tvUpdGarantiasCliente.setText(Html.fromHtml("<b>Últimas fotos Garantías:</b><br>" + updateGarantiasCliente));
                    tvUpdComprobantesCliente.setText(Html.fromHtml("<b>Últimas fotos Comprobantes:</b><br>" + updateComprobantesCliente));

                    tvUpdGarantiasAval.setText(Html.fromHtml("<b>Últimas fotos Garantías:</b><br>" + updateGarantiasAval));
                    tvUpdComprobantesAval.setText(Html.fromHtml("<b>Últimas fotos Comprobantes:</b><br>" + updateComprobantesAval));

                    if (clientes.get(position).getLatitud() != null && clientes.get(position).getLongitud() != null) {
                        tvUbicacionCliente.setText(Html.fromHtml("<b>Ver ubicación"));
                    } else {
                        tvUbicacionCliente.setVisibility(View.GONE);
                    }

                    tvNombreAval.setText(Html.fromHtml("<b>Aval:</b> " + clientes.get(position).getNombre_aval()));
                    tvDireccionAval.setText(Html.fromHtml("<b>Dirección:</b> " + clientes.get(position).getDireccion_aval()));
                    tvTelefonoAval.setText(Html.fromHtml("<b>Teléfono:</b> " + clientes.get(position).getTelefono_aval()));
                    tvORAval.setText(Html.fromHtml("<b>Otras referencías:</b> " + clientes.get(position).getOtras_referencias_aval()));
                    tvGarantiasAval.setText(Html.fromHtml("<b>Garantías:</b> " + clientes.get(position).getGarantias_aval()));

                    tvUbicacionCliente.setOnClickListener(view1 -> {
                        Intent i = new Intent(Intent.ACTION_VIEW,
                                Uri.parse("google.navigation:q=" + clientes.get(position).getLatitud() + "," + clientes.get(position).getLongitud() + "&mode=d"));

                        i.setPackage("com.google.android.apps.maps");
                        context.startActivity(i);

                    });

                    tvTelefonoCliente.setOnClickListener(view12 -> {
                        Intent intent = new Intent(Intent.ACTION_DIAL);
                        intent.setData(Uri.parse("tel:" + clientes.get(position).getTelefono()));
                        context.startActivity(intent);
                    });

                    tvTelefonoAval.setOnClickListener(view13 -> {
                        Intent intent = new Intent(Intent.ACTION_DIAL);
                        intent.setData(Uri.parse("tel:" + clientes.get(position).getTelefono_aval()));
                        context.startActivity(intent);
                    });

                    new MaterialAlertDialogBuilder(context)
                            .setTitle("")
                            .setView(dialogView)
                            .setPositiveButton("Cerrar", (dialogInterface, i) -> {

                            })
                            .show();
                });
            }
        }
    }

    private String formatFecha(String fecha) {
        if (fecha == null) {
            return "...";
        }

        SimpleDateFormat originalFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat desiredFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        try {
            Date date = originalFormat.parse(fecha);
            return desiredFormat.format(date);
        } catch (ParseException | java.text.ParseException e) {
            e.printStackTrace();
            return "...";
        }
    }
    public void activarPrestanombre(String clientId) {
        VolleyS vs = VolleyS.getInstance(context);
        RequestQueue requestQueue = vs.getRequestQueue();
        requestQueue.getCache().clear();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "prestanombre_activar");
            data.put("id", clientId);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        Log.d("4", "loadAllData: ");

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            String status = response.getString("status");
                            if (status.equals("success")) {
                                // La activación del prestanombre fue exitosa, ahora obtener los datos del cliente

                                Toast.makeText(context, "Cliente actualizado", Toast.LENGTH_SHORT).show();
                                Log.d("DEBUG", "Respuesta del servidor: " + status);
                            } else {
                                // Manejar el caso si la activación falla
                                Toast.makeText(context, "Error en la activación del prestanombre", Toast.LENGTH_SHORT).show();
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                            Toast.makeText(context, "Error al procesar la respuesta", Toast.LENGTH_SHORT).show();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                // Manejar errores de red o de la solicitud
                Toast.makeText(context, "Error en la solicitud", Toast.LENGTH_SHORT).show();
            }
        });

        // Establecer la política de reintento
        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        // Agregar la solicitud a la cola
        requestQueue.add(request);
    }

}